<?php

namespace App\Models\Academic;

use App\Models\HrPayroll\Employee;
use App\Models\Scopes\BranchFilterScope;
use App\Models\Student\StudentInfo;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassSection extends Model
{
    use HasFactory;
    protected $guarded = [];
    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'student_class_id');
    }

    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id');
    }

    public function classTeacher()
    {
        return $this->belongsTo(User::class, 'class_teacher_id')->where('user_type','teacher');
    }

    public function students()
    {
        return $this->hasMany(StudentInfo::class, 'student_class_id', 'student_class_id')
                    ->whereColumn('class_sections.section_id', 'student_infos.section_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
