<?php

namespace App\Models\Academic;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Section extends Model
{
    use HasFactory;
    protected $fillable = [
        'section_name',
        'student_class_id',
        'created_by',
        'updated_by'
    ];

    public function studentClass(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class);
    }
    public function classSections()
    {
        return $this->hasMany(ClassSection::class, 'section_id');
    }
}
