<?php

namespace App\Models\Academic;

use App\Models\Notice;
use App\Models\Student\StudentInfo;
use App\Models\StudentInfoSubjectClass;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\hasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentClass extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $table = 'student_classes';

    public function classTimePeriods()
    {
        return $this->hasMany(ClassTimePeriod::class, 'student_class_id', 'id');
    }

    public function sections(): hasMany
    {
        return $this->hasMany(Section::class);
    }

    public function classSections()
    {
        return $this->hasMany(ClassSection::class, 'student_class_id');
    }

    public function subjectAssignments()
    {
        return $this->hasMany(SubjectsAssign::class, 'student_class_id', 'id');
    }

    public function students()
    {
        return $this->hasMany(StudentInfo::class, 'class_id');
    }

    public function studentInfoMappings()
    {
        return $this->hasMany(StudentInfoSubjectClass::class);
    }

    public function notices()
    {
        return $this->belongsToMany(Notice::class, 'notice_student_class');
    }


}
