<?php

namespace App\Models\Academic;

use App\Models\StudentInfoSubjectClass;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subject extends Model
{
    use HasFactory;
    protected $guarded = [];
    protected $table = 'subjects';

    public function classTimePeriods()
    {
        return $this->hasMany(ClassTimePeriod::class, 'subject_id', 'subject_id');
    }

    public function subjectAssignments()
    {
        return $this->hasMany(SubjectsAssign::class, 'subject_id', 'id');
    }

    public function studentInfoMappings()
    {
        return $this->hasMany(StudentInfoSubjectClass::class);
    }
}
