<?php

namespace App\Models\Accounting;

use App\Models\Academic\StudentClass;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassFee extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_class_id',
        'academic_year_id',
        'branch_id',
        'month',
        'department_id',
        'fee_type_id',
        'amount'
    ];

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class,'student_class_id');
    }

    public function feeType()
    {
        return $this->belongsTo(FeeType::class);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }

}
