<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Accounting\AccountingHead;

class ExpenseItem extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'expense_head_id'];

    public function expenseHead()
    {
        return $this->belongsTo(AccountingHead::class, 'expense_head_id');
    }
} 