<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeType extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function feeCycleType()
    {
        return $this->belongsTo(FeeCycleType::class, 'fee_cycle_type_id');
    }

    public function classFee()
    {
        return $this->hasMany(ClassFee::class);
    }

    public function invoiceItem()
    {
        return $this->hasMany(InvoiceItem::class);
    }

    
}
