<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Model;
use App\Models\Accounting\AccountingHead;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class IncomeItem extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'income_head_id'];

    public function incomeHead()
    {
        return $this->belongsTo(AccountingHead::class, 'income_head_id');
    }
}
