<?php

namespace App\Models\Accounting;

use App\Models\Accounting\FeeType;
use App\Models\Accounting\Invoice;
use App\Models\Accounting\StudentFee;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InvoiceItem extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [];



    public function feeType()
    {
        return $this->belongsTo(FeeType::class);
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function studentFee()
    {
        return $this->belongsTo(StudentFee::class);
    }
    
}
