<?php

namespace App\Models\Admission;

use App\Models\Academic\Branch;
use App\Models\Academic\Department;
use App\Models\Academic\StudentClass;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AdmissionFee extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'student_class_id');
    }
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
