<?php

namespace App\Models\Admission;

use App\Models\Academic\Shift;
use App\Models\Academic\Department;
use App\Models\Academic\StudentClass;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OnlineAdmission extends Model
{
    use HasFactory;


    protected $guarded = [];

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'student_class_id');
    }
    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);

        static::creating(function ($admission) {

            if (empty($admission->form_id)) {

                // Year last two digits (2026 => 26)
                $year = now()->format('y');

                // Last form_id for same branch & year
                $lastId = static::where('branch_id', $admission->branch_id)
                    ->where('form_id', 'like', $year . '%')
                    ->max('form_id');

                if ($lastId) {
                    // Get numeric sequence part and increment
                    $sequence = ((int) substr($lastId, 2)) + 1;
                } else {
                    $sequence = 1001;
                }

                // Combine year + sequence (NO SPACE)
                $admission->form_id = (int) ($year . $sequence);
            }
        });
    }


}
