<?php

namespace App\Models\Homework;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Academic\Shift;
use App\Models\Academic\Group;
use App\Models\Academic\Branch;
use App\Models\Academic\Section;
use App\Models\Academic\Subject;
use App\Models\Academic\Department;
use App\Models\Academic\StudentClass;

use App\Models\Homework\HomeworkSubmission;
class Homework extends Model
{
    use HasFactory;
    protected $table = 'homeworks';

    public function shift(){
        return $this->belongsTo(Shift::class);
    }
    public function group(){
        return $this->belongsTo(Group::class);
    }
    public function branch(){
        return $this->belongsTo(Branch::class);
    }
    public function section(){
        return $this->belongsTo(Section::class);
    }
    public function subject(){
        return $this->belongsTo(Subject::class);
    }
    public function department(){
        return $this->belongsTo(Department::class);
    }
    public function studentClass(){
        return $this->belongsTo(StudentClass::class);
    }
    public function homeworkSubmission()
    {
        return $this->hasOne(HomeworkSubmission::class);
    }
}
