<?php

namespace App\Models\Homework;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Homework\Homework;
use App\Models\Student\StudentInfo;

class HomeworkSubmission extends Model
{
    use HasFactory;

    protected $fillable = [
        'marks',
        'status',
        'created_by',
        'updated_by'
    ];

    public function homework(){
        return $this->belongsTo(Homework::class);
    }

    public function student(){
        return $this->belongsTo(StudentInfo::class,'student_id');
    }
}
