<?php

namespace App\Models\Hostel;

use App\Models\Academic\Branch;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hostel extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function rooms()
    {
        return $this->hasMany(HostelRoom::class);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
