<?php

namespace App\Models\HrPayroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Designation extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'position'];

    protected $table = 'designations';

    public function employee()
    {
        return $this->hasMany(Employee::class, 'designation_id');
    }

    public function employeeAttendance()
    {
        return $this->hasMany(EmployeeAttendance::class, 'designation_id');
    }

    public function employeeEducation()
    {
        return $this->hasMany(EmployeeEducation::class, 'designation_id');
    }

    public function employeeSalary()
    {
        return $this->hasMany(EmployeeSalary::class, 'designation_id');
    }


    public function employeeType()
    {
        return $this->hasMany(EmployeeType::class, 'designation_id');
    }

    public function hrDepartment()
    {
        return $this->hasMany(HrDepartment::class, 'designation_id');
    }

    public function leave()
    {
        return $this->hasMany(Leave::class, 'designation_id');
    }

    public function leaveType()
    {
        return $this->hasMany(LeaveType::class, 'designation_id');
    }

    public function monthlySalary()
    {
        return $this->hasMany(MonthlySalary::class, 'designation_id');
    }

    public function occupation()
    {
        return $this->hasMany(Occupation::class, 'designation_id');
    }

    public function salaryGrade()
    {
        return $this->hasMany(SalaryGrade::class, 'designation_id');
    }
    public function salaryGradeRule()
    {
        return $this->hasMany(SalaryGradeRule::class, 'designation_id');
    }

    public function salaryHead()
    {
        return $this->hasMany(SalaryHead::class, 'designation_id');
    }

    public function teacher()
    {
        return $this->hasMany(Teacher::class, 'designation_id');
    }






    

    
}
