<?php

namespace App\Models\HrPayroll;

use App\Models\Scopes\BranchFilterScope;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Leave extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
