<?php

namespace App\Models\HrPayroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class SalaryGrade extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'code',
        'status',
    ];

    public function salaryGradeRules()
    {
        return $this->hasMany(SalaryGradeRule::class);
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'salary_grade_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->code = $model->generateCode();
        });
    }

    public function generateCode()
    {
        $code = Str::upper(Str::slug($this->title));
        return Str::limit($code, 15, '');
    }
}
