<?php

namespace App\Models\HrPayroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class SalaryHead extends Model
{
    use HasFactory;

    protected $fillable = ['title', 'type'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->code = $model->generateCode();
        });
    }

    public function generateCode()
    {
        $code = Str::upper(Str::snake($this->title));
        return Str::limit($code, 15, '');
    }
}
