<?php

namespace App\Models\Hsc;

use App\Models\Academic\Group;
use App\Models\Academic\Subject;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GroupSubject extends Model
{
    use HasFactory;

    public const COMPULSORY = 'compulsory';
    public const ELECTIVE = 'elective';
    public const OPTIONAL = 'optional';

    public const SUBJECT_GROUP_TYPE = [
        self::COMPULSORY,
        self::ELECTIVE,
        self::OPTIONAL,
    ];

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    protected $fillable = ['name','group_id','subject_id','type','is_main','is_common'];

    protected $table = 'group_subjects';

}
