<?php

namespace App\Models\Hsc;

use Illuminate\Database\Eloquent\Model;
use App\Models\Guardian\GuardianRelation;
use Devfaysal\BangladeshGeocode\Models\Union;
use Devfaysal\BangladeshGeocode\Models\Upazila;
use Devfaysal\BangladeshGeocode\Models\District;
use Devfaysal\BangladeshGeocode\Models\Division;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class HscAdmission extends Model
{
    use HasFactory;



    protected $fillable = [
        'admission_roll', 'branch_id', 'session_year', 'class_roll', 'merit_position',
        'first_name', 'last_name', 'email', 'applicant_mobile', 'blood_group', 'nid', 'dob',
        'marital_status', 'gender', 'nationality', 'religion', 'profile_image',
        'board_select', 'passing_year', 'institute_name', 'ssc_roll_num',
        'ssc_reg_num', 'ssc_session', 'ssc_gpa', 
        'main_subject1','main_subject2','main_subject3','main_subject4', 'main_subject5','elective_subject1','elective_subject2','elective_subject3',
        'optional_subject', 'father_name', 'father_nid', 'father_dob',
        'father_mobile', 'father_occupation', 'father_income', 'mother_name',
        'mother_nid', 'mother_dob', 'mother_mobile', 'mother_occupation',
        'mother_income', 'guardian_selection', 'guardian_name', 'guardian_relation', 'guardian_address', 'gardian_nid',
        'guardian_mobile', 'village_present', 'post_present', 'police_present',
        'district_present', 'postcode_present', 'same_as_present',
        'village_permanent', 'post_permanent', 'police_permanent',
        'district_permanent', 'postcode_permanent', 'special_quata', 'community',
        'group_payment', 'payment_from_account', 'payment_amount',
        'payment_tnxid', 'hscgruop',
        'present_division_id',
    'present_district_id',
    'present_upazila_id',
    'present_union_id',
    'present_address',
    'permanent_division_id',
    'permanent_district_id',
    'permanent_upazila_id',
    'permanent_union_id',
    'permanent_address',
    'selected'
    ];


    public function presentDivision()
    {
        return $this->belongsTo(Division::class, 'present_division_id');
    }

    public function presentDistrict()
    {
        return $this->belongsTo(District::class, 'present_district_id');
    }
    public function presentUnion()
    {
        return $this->belongsTo(Union::class, 'present_union_id');
    }
    public function presentUpazila()
    {
        return $this->belongsTo(Upazila::class, 'present_upazila_id');
    }
    public function permanentDivision()
    {
        return $this->belongsTo(Division::class, 'permanent_division_id');
    }
    public function permanentDistrict()
    {
        return $this->belongsTo(District::class, 'permanent_district_id');
    }
    public function permanentUnion()
    {
        return $this->belongsTo(Union::class, 'permanent_union_id');
    }
    public function permanentUpazila()
    {
        return $this->belongsTo(Upazila::class, 'permanent_upazila_id');
    }

    public function guardianRelation()
    {
        return $this->belongsTo(GuardianRelation::class, 'guardian_relation');
    }
}
