<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Scopes\BranchFilterScope;
use App\Models\Accounting\AccountingHead;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'name',
        'code',
        'image',
        'purchase_price',
        'sale_price',
        'current_stock',
        'description',
        'created_by',
        'updated_by'
    ];


    public function accountingHead()
    {
        return $this->belongsTo(AccountingHead::class, 'accounting_head_id');
    }

    
    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
    
}
