<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Inventory\StockOut;
use App\Models\Student\StudentInfo;

class TransactionMaster extends Model
{
    use HasFactory;
    protected $guarded = [];
    protected $table = 'transaction_master';

    public function stockIn()
    {
        return $this->hasMany(StockIn::class, 'transaction_id');
    }

    public function stockOut()
    {
        return $this->hasMany(StockOut::class, 'transaction_id');
    }

    public function student()
    {
        return $this->belongsTo(StudentInfo::class, 'student_id','student_id_no');
    }
} 