<?php

namespace App\Models\Library;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

use App\Models\Library\Booklist;
use App\Models\Library\Bookmember;

class Bookissue extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'booklist_id',
        'bookmember_id',
        'issue_date',
        'estimate_return_date',
        'return_date',
        'status',
        'created_by',
        'updated_by'
    ];


    public function user(){
        return $this->belongsTo(User::class);
    }

    public function issueBy(){
        return $this->belongsTo(User::class,'created_by');
    }

    public function booklist(){
        return $this->belongsTo(Booklist::class);
    }
    public function Bookmember(){
        return $this->belongsTo(Bookmember::class);
    }
}
