<?php

namespace App\Models\Library;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\User;
use App\Models\Library\Bookissue;

class Booklist extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'book_number',
        'isbn_number',
        'publisher',
        'author',
        'subject',
        'rack_number',
        'quantity',
        'price',
        'postdate',
        'description',
        'status',
        'created_by',
        'updated_by'
    ];

    public function user(){
        return $this->hasOne(User::class, 'id','created_by');
    }

    public function bookissue()
    {
        return $this->hasMany(Bookissue::class, 'user_id');
    }
}
