<?php

namespace App\Models\Library;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Library\Bookissue;

class Bookmember extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id','member_ud_id','status','created_by','updated_by'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function bookissue()
    {
        return $this->hasMany(Bookissue::class, 'user_id');
    }
}
