<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Academic\StudentClass;

class Notice extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'description',
        'attachment',
        'publish_date',
        'status',
        'created_by',
        'branch_id'
    ];
    
    public function studentClasses()
    {
        return $this->belongsToMany(StudentClass::class, 'notice_student_class');
    }

}
