<?php

namespace App\Models\Result;

use App\Models\Academic\AcademicYear;
use App\Models\Syllabus\Lesson;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function academic_year()
    {
        return $this->belongsTo(AcademicYear::class, 'year');
    }

    
    public function markHeadAssigns()
    {
        return $this->hasMany(MarkHeadAssign::class, 'exam_id');
    }

    public function examPublishes()
    {
        return $this->hasMany(ExamPublish::class, 'exam_id');
    }

    public function examRecords()
    {
        return $this->hasMany(ExamRecord::class, 'exam_id');
    }    

    public function examRoutines()
    {
        return $this->hasMany(ExamRoutine::class, 'exam_id');
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class, 'exam_id');
    }
  

}
