<?php

namespace App\Models\Result;

use App\Models\Academic\AcademicYear;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamPublish extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function exam()
    {
        return $this->belongsTo(Exam::class, 'exam_id');
    }
    public function academic_year()
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
