<?php

namespace App\Models\Result;

use App\Models\Academic\AcademicYear;
use App\Models\Academic\Group;
use App\Models\Academic\Section;
use App\Models\Academic\StudentClass;
use App\Models\Academic\Subject;
use App\Models\Scopes\BranchFilterScope;
use App\Models\Student\StudentInfo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamRecord extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function exam()
    {
        return $this->belongsTo(Exam::class, 'exam_id');
    }

    public function student()
    {
        return $this->belongsTo(StudentInfo::class, 'student_id');
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id');
    }

    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class, 'year');
    }

    public function markHead()
    {
        return $this->belongsTo(MarkHead::class, 'mark_head_id');
    }

    public function scopeForClass($query, $classId)
    {
        return $query->where('class_id', $classId);
    }

    public function scopeForExam($query, $examId, $year)
    {
        return $query->where('exam_id', $examId)
                    ->where('year', $year);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }

}
