<?php

namespace App\Models\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class BranchFilterScope implements Scope
{
    public function apply(Builder $builder, Model $model)
    {
        $branchId = auth()->user()?->branch_id ?? null;
        $tableName = $model->getTable();
        $builder->where("{$tableName}.branch_id", $branchId);
    }
}
