<?php

namespace App\Models;

use App\Models\Scopes\BranchFilterScope;
use App\Models\Student\StudentInfo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SmsRecord extends Model
{
    use HasFactory;
    protected $guarded = [];
    public $timestamps = false;

    public function userInfo()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function studentInfo()
    {
        return $this->belongsTo(StudentInfo::class, 'student_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
