<?php

namespace App\Models\Student;

use App\Models\User;
use App\Models\GuardianInfo;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Academic\Branch;
use App\Models\Academic\Section;
use App\Models\Result\ExamRecord;
use App\Traits\LogsActivityTrait;
use App\Models\Hostel\StudentHostel;
use App\Models\Academic\ClassSection;
use App\Models\Academic\StudentClass;
use App\Models\StudentInfoSubjectClass;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scopes\BranchFilterScope;
use App\Models\Transport\StudentTransport;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Models\Attendance\StudentAttendance;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentInfo extends Model
{
    use HasFactory, LogsActivity, LogsActivityTrait;

    protected $guarded = [];


    public function StudentInfoSubjectClass()
    {
        return $this->hasMany(StudentInfoSubjectClass::class);
    }


    protected function logName(): string
    {
        return 'student';
    }

    public function subjectClassMappings()
    {
        return $this->hasMany(StudentInfoSubjectClass::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'student_class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }

    public function classSection()
    {
        return $this->belongsTo(ClassSection::class, 'student_class_id', 'student_class_id')
                    ->where('section_id', $this->section_id);
    }

    public function attendance()
    {
        return $this->hasOne(StudentAttendance::class, 'student_id');
    }

    public function attendances()
    {
        return $this->hasMany(StudentAttendance::class, 'student_id');
    }

    public function presentCount(){
        return StudentAttendance::where('student_id', $this->id)
            ->where('is_present', 1)
            ->count();
    }

    public function examRecords()
    {
        return $this->hasMany(ExamRecord::class, 'student_id')
                    ->orderBy('year', 'desc')
                    ->orderBy('subject_id');
    }

    public function examRecordsForClass($classId)
    {
        return $this->examRecords()
                    ->where('class_id', $classId);
    }

    public function studentHostel()
    {
        return $this->hasOne(StudentHostel::class, 'student_id');
    }

    public function studentHostelRoom()
    {
        return $this->hasOne(StudentHostel::class, 'student_id');
    }

    public function studentTransport()
    {
        return $this->hasOne(StudentTransport::class, 'student_id');
    }

    public function guardianInfo()
    {
        return $this->hasOne(GuardianInfo::class, 'student_id');
    }

    public function siblings()
    {
        return $this->belongsToMany(StudentInfo::class, 'siblings', 'student_id', 'sibling_id');
    }

    public function reverseSiblings()
    {
        return $this->belongsToMany(StudentInfo::class, 'siblings', 'sibling_id', 'student_id');
    }

    public function allSiblings()
    {
        // Get direct siblings
        $directSiblings = $this->siblings;
    
        // Initialize a collection to hold all siblings
        $allSiblings = collect($directSiblings);
    
        // Loop through each direct sibling to get their siblings
        foreach ($directSiblings as $sibling) {
            $siblingSiblings = $sibling->siblings; // Get siblings of the sibling
            $allSiblings = $allSiblings->merge($siblingSiblings); // Merge them into the collection
        }
    
        // Remove duplicates and exclude the current student
        return $allSiblings->unique('id')->reject(function ($sibling) {
            return $sibling->id === $this->id; // Exclude the current student
        });
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
