<?php

namespace App\Models\Student;

use App\Models\Academic\AcademicYear;
use App\Models\Academic\Branch;
use App\Models\Academic\Department;
use App\Models\Academic\Section;
use App\Models\Academic\Shift;
use App\Models\Academic\StudentClass;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentPromotion extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function student()
    {
        return $this->belongsTo(StudentInfo::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function fromShift()
    {
        return $this->belongsTo(Shift::class);
    }

    public function fromAcademicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function fromDepartment()
    {
        return $this->belongsTo(Department::class);
    }

    public function fromClass()
    {
        return $this->belongsTo(StudentClass::class);
    }

    public function fromSection()
    {
        return $this->belongsTo(Section::class);
    }

    public function toShift()
    {
        return $this->belongsTo(Shift::class);
    }

    public function toAcademicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function toDepartment()
    {
        return $this->belongsTo(Department::class);
    }

    public function toClass()
    {
        return $this->belongsTo(StudentClass::class);
    }

    public function toSection()
    {
        return $this->belongsTo(Section::class);
    }
}
