<?php

namespace App\Models;

use App\Models\Academic\Subject;
use App\Models\Student\StudentInfo;
use App\Models\Academic\StudentClass;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentInfoSubjectClass extends Model
{
    use HasFactory;
    protected $table = 'student_info_subject_class';

    protected $fillable = ['student_info_id', 'subject_id', 'student_class_id','subject_type'];

    public function studentInfo()
    {
        return $this->belongsTo(StudentInfo::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class);
    }
    
}
