<?php

namespace App\Models\Syllabus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Academic\Subject;
use App\Models\Academic\StudentClass;
use App\Models\Syllabus\LessonTopic;
use App\Models\Result\Exam;

class Lesson extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $fillable = [
        'exam_id',
        'student_class_id',
        'subject_id',
        'name',
        'created_at',
        'updated_at',
    ];



    public function exam(){
        return $this->belongsTo(Exam::class);
    }

    public function studentClass(){
        return $this->belongsTo(StudentClass::class);
    }

    public function subject(){
        return $this->belongsTo(Subject::class);
    }
    
    public function lessonTopics(){
        return $this->hasMany(LessonTopic::class);
    }

    
}
