<?php

namespace App\Models\Syllabus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Academic\Section;
use App\Models\Academic\Subject;
use App\Models\Academic\StudentClass;
use App\Models\Syllabus\Lesson;

class LessonTopic extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_class_id',
        'subject_id',
        'lesson_id',
        'name',
        'created_at',
        'updated_at',
    ];

    public function lesson(){
        return $this->belongsTo(Lesson::class);
    }
    public function studentClass(){
        return $this->belongsTo(StudentClass::class);
    }
    public function subject(){
        return $this->belongsTo(Subject::class);
    }
}
