<?php

namespace App\Models\Transport;

use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stoppage extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function transportRoute()
    {
        return $this->belongsTo(TransportRoute::class);
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
