<?php

namespace App\Models\Transport;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Student\StudentInfo;
use App\Models\Transport\TransportRoute;
use App\Models\Transport\Stoppage;
class StudentTransport extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function transportRoute()
    {
        return $this->belongsTo(TransportRoute::class, 'route_id');
    }

    public function stoppage()
    {
        return $this->belongsTo(Stoppage::class, 'stoppage_id');
    }

    public function studentInfo()
    {
        return $this->belongsTo(StudentInfo::class,'student_id', 'id');
    }

}
