<?php

namespace App\Models\Transport;

use App\Models\Transport\Vehicle;
use App\Models\HrPayroll\Employee;
use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransportRoute extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'driver_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }
}
