<?php

namespace App\Models\Transport;

use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }


    public function transportRoute()
    {
        return $this->hasMany(TransportRoute::class);
    }
}
