<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Models\Academic\Branch;
use App\Models\Library\Bookmember;
use App\Models\Library\Bookissue;
use App\Models\Student\StudentInfo;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    protected $guarded = [];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

    public function studentInfo()
    {
        return $this->hasOne(StudentInfo::class, 'user_id');
    }

    public function bookmember()
    {
        return $this->hasMany(Bookmember::class, 'user_id');
    }

    public function bookissue()
    {
        return $this->hasMany(Bookissue::class, 'user_id');
    }
}
