<?php

namespace App\Providers;

use App\Models\Academic\AcademicYear;
use App\Services\Sms\Providers\MuthobartaSmsProvider;
use App\Services\Sms\SmsService;
use App\View\Composers\NavbarComposer;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SmsService::class, function () {
            return new SmsService(new MuthobartaSmsProvider());
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Model::preventLazyLoading(!app()->isProduction());
        if(env('FORCE_HTTPS',false)) {
            URL::forceScheme('https');
        }

        $bloodGroupOptions = [
            'A+' => 'A+',
            'A-' => 'A-',
            'B+' => 'B+',
            'B-' => 'B-',
            'AB+' => 'AB+',
            'AB-' => 'AB-',
            'O+' => 'O+',
            'O-' => 'O-',
        ];
        View::share('bloodGroupOptions',$bloodGroupOptions);

        $religionOptions = [
            'Islam' => 'Islam',
            'Christianity' => 'Christianity',
            'Hinduism' => 'Hinduism',
            'Buddhism' => 'Buddhism',
            'Judaism' => 'Judaism',
            'Sikhism' => 'Sikhism',
            'Other' => 'Other',
        ];
        View::share('religionOptions',$religionOptions);

        $genderOptions = [
            'male' => 'Male',
            'female' => 'Female',
        ];
        View::share('genderOptions',$genderOptions);

        View::share('months',config('months'));

        $defaultYear = Cache::remember('default_academic_year', 60 * 60, function () {
            return AcademicYear::where('is_default_year', 'yes')->first()?->id;
        });

        View::share('defaultYear', $defaultYear);

        View::composer('partials.navbar', NavbarComposer::class);

        $mainPath = database_path('migrations');
        $directories = glob($mainPath . '/*' , GLOB_ONLYDIR);
        $paths = array_merge([$mainPath], $directories);

        $this->loadMigrationsFrom($paths);
    }

}
