<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class IBBLServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->singleton('ibbl', function ($app) {
            return new \stdClass();
        });
    }

    public function boot()
    {
        // Force load IBBL config
        config([
            'ibbl.user_id' => env('IBBL_USER_ID', 'ibbl_cf_1001'),
            'ibbl.iid' => env('IBBL_IID', '1001'),
            'ibbl.password' => env('IBBL_PASSWORD', '123456'),
        ]);
    }
} 