<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));

                

            Route::middleware('academic')
                ->group(base_path('routes/academic.php'));
            Route::prefix('academic')
                ->middleware(['academic'])
                ->namespace($this->namespace)
                ->group(base_path('routes/academic.php'));

            Route::middleware('admission')
                ->group(base_path('routes/admission.php'));
            Route::prefix('admission')
                ->middleware(['admission'])
                ->namespace($this->namespace)
                ->group(base_path('routes/admission.php'));

            Route::middleware('student')
                ->group(base_path('routes/student.php'));
            Route::prefix('student')
                ->middleware(['student'])
                ->namespace($this->namespace)
                ->group(base_path('routes/student.php'));

            Route::middleware('teacher')
                ->group(base_path('routes/teacher.php'));
            Route::prefix('teacher')
                ->middleware(['teacher'])
                ->namespace($this->namespace)
                ->group(base_path('routes/teacher.php'));

            Route::middleware('hr')
                ->group(base_path('routes/hr.php'));
            Route::prefix('hr')
                ->middleware(['hr'])
                ->namespace($this->namespace)
                ->group(base_path('routes/hr.php'));

            Route::middleware('result')
                ->group(base_path('routes/result.php'));
            Route::prefix('result')
                ->middleware(['result'])
                ->namespace($this->namespace)
                ->group(base_path('routes/result.php'));

            Route::middleware('attendance')
                ->group(base_path('routes/attendance.php'));
            Route::prefix('attendance')
                ->middleware(['attendance'])
                ->namespace($this->namespace)
                ->group(base_path('routes/attendance.php'));

            Route::middleware('accounting')
                ->group(base_path('routes/accounting.php'));
            Route::prefix('accounting')
                ->middleware(['accounting'])
                ->namespace($this->namespace)
                ->group(base_path('routes/accounting.php'));

            Route::middleware('hostel')
                ->group(base_path('routes/hostel.php'));
            Route::prefix('hostel')
                ->middleware(['hostel'])
                ->namespace($this->namespace)
                ->group(base_path('routes/hostel.php'));

            Route::middleware('transport')
                ->group(base_path('routes/transport.php'));
            Route::prefix('transport')
                ->middleware(['transport'])
                ->namespace($this->namespace)
                ->group(base_path('routes/transport.php'));

            Route::middleware('library')->group(base_path('routes/library.php'));
            Route::prefix('library')
                ->middleware(['library'])
                ->namespace($this->namespace)
                ->group(base_path('routes/library.php'));

            Route::middleware('report')->group(base_path('routes/report.php'));
            Route::prefix('report')
                ->middleware(['report'])
                ->namespace($this->namespace)
                ->group(base_path('routes/report.php'));   

            Route::middleware('syllabus')->group(base_path('routes/syllabus.php'));
            Route::prefix('syllabus')
                ->middleware(['syllabus'])
                ->namespace($this->namespace)
                ->group(base_path('routes/syllabus.php'));       

            Route::middleware('homework')->group(base_path('routes/homework.php'));
            Route::prefix('homework')
                ->middleware(['homework'])
                ->namespace($this->namespace)
                ->group(base_path('routes/homework.php')); 

            Route::middleware('holiday')->group(base_path('routes/holiday.php'));
            Route::prefix('holiday')
                ->middleware(['holiday'])
                ->namespace($this->namespace)
                ->group(base_path('routes/holiday.php')); 

            Route::middleware('inventory')->group(base_path('routes/inventory.php'));
            Route::prefix('inventory')
                ->middleware(['inventory'])
                ->namespace($this->namespace)
                ->group(base_path('routes/inventory.php'));

            Route::middleware('student-info')->group(base_path('routes/student-info.php'));
            Route::prefix('student-info')
                ->middleware(['student-info'])
                ->namespace($this->namespace)
                ->group(base_path('routes/student-info.php')); 

            Route::middleware('hsc')->group(base_path('routes/hsc.php'));
            Route::prefix('hsc')
                ->middleware(['hsc'])
                ->namespace($this->namespace)
                ->group(base_path('routes/hsc.php')); 
 

        });
    }
}
