<?php
namespace App\Services\Accounting;

use App\Constants\Accounting;
use App\Constants\Settings;
use App\Constants\Status;
use App\Models\Academic\Branch;
use App\Models\Accounting\ClassFee;
use App\Models\Accounting\FeeInvoice;
use App\Models\Accounting\FeeType;
use App\Models\Accounting\Income;
use App\Models\Accounting\InvoiceItem;
use App\Models\Accounting\StudentDiscount;
use App\Models\Hostel\StudentHostel;
use App\Models\Scopes\BranchFilterScope;
use App\Models\Student\StudentInfo;
use App\Models\Transport\StudentTransport;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class FeeInvoiceService
{

    public function createFeeInvoice($class)
    {
        DB::beginTransaction();

        try {
            $query = StudentInfo::where('student_class_id', $class);

            // $classFeesQuery = ClassFee::with(['feeType'=> function ($query) {
            //     $query->whereNotIn('code', ['TRANSPORT','HOSTEL']);
            // }])->where('student_class_id', $class);
            $classFeesQuery = ClassFee::with(['feeType'])->where('student_class_id', $class);


            $students = $query->get();
            $classFees = $classFeesQuery->get();
            
            foreach($students as $student){
                $this->createStudentFeeInvoice($student, $classFees);
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error processing daily collection: ' . $e->getMessage());
            throw $e;
        }
    }


    public function createStudentFeeInvoice($student, $classFees)
    {

        $discount = StudentDiscount::where('student_id', $student->id)->first();
        $feeInvoiceData = [];
        foreach($classFees as $fees){
            $feeInvoiceData[] = [
                'student_id' => $student->id,
                'student_class_id' => $student->student_class_id,
                'section_id' => $student->section_id,
                'shift_id' => $student->shift_id,
                'fee_type_id' => $fees->fee_type_id,
                'amount' => $fees->amount,
                // 'payable_amount' => $fees->amount,
                'academic_year_id' => 1,
            ];
        }

        $studentTransport = $this->getStudentTransport($student->id);

        if($studentTransport){
            $transportFeeType = FeeType::where('code','TRANSPORT')->get();
           
            foreach($transportFeeType as $transportFee){
                $feeInvoiceData[] = [
                    'student_id' => $student->id,
                    'student_class_id' => $student->student_class_id,
                    'section_id' => $student->section_id,
                    'shift_id' => $student->shift_id,
                    'fee_type_id' => $transportFee->id,
                    'amount' => $studentTransport->monthly_cost,
                    // 'payable_amount' => $studentTransport->monthly_cost,
                    'academic_year_id' => 1,
                ];
            }
        }

        $studentHostel = $this->getStudentHostel($student->id);

        if($studentHostel){
            $hostelFeeType = FeeType::where('code','HOSTEL')->get();
           
            foreach($hostelFeeType as $hostelFee){
                $feeInvoiceData[] = [
                    'student_id' => $student->id,
                    'student_class_id' => $student->student_class_id,
                    'section_id' => $student->section_id,
                    'shift_id' => $student->shift_id,
                    'fee_type_id' => $hostelFee->id,
                    'amount' => $studentHostel->monthly_cost,
                    // 'payable_amount' => $studentHostel->monthly_cost,
                    'academic_year_id' => 1,
                ];
            }
        }

        FeeInvoice::insert($feeInvoiceData);

    }

    public function getStudentTransport($student_id)
    {
        return StudentTransport::where('student_id', $student_id)->first();
    }

    public function getStudentHostel($student_id)
    {
        return StudentHostel::where('student_id', $student_id)->first();
    }

    //TODO: this is for daily collection to income task schedule
    public function storeDailyCollectionToIncome()
    {
        $hifzBoysFeesIncomeHeadId = get_setting_value(Settings::HIFZ_BOYS_FEES_INCOME_HEAD);
        $hifzGirlsFeesIncomeHeadId = get_setting_value(Settings::HIFZ_GIRLS_FEES_INCOME_HEAD);
        $nuraniFeesIncomeHeadId = get_setting_value(Settings::NURANI_FEES_INCOME_HEAD);
        $kawmiFeesIncomeHeadId = get_setting_value(Settings::KAWMI_FEES_INCOME_HEAD);

        $examFeeIncomeHeadId = get_setting_value(Settings::EXAM_FEE_INCOME_HEAD);

        $hifzBoysAdmissionIncomeHeadId = get_setting_value(Settings::HIFZ_BOYS_ADMISSION_INCOME_HEAD);
        $hifzGirlsAdmissionIncomeHeadId = get_setting_value(Settings::HIFZ_GIRLS_ADMISSION_INCOME_HEAD);
        $nuraniAdmissionIncomeHeadId = get_setting_value(Settings::NURANI_ADMISSION_INCOME_HEAD);
        $kawmiAdmissionIncomeHeadId = get_setting_value(Settings::KAWMI_ADMISSION_INCOME_HEAD);

        $aliyaFeesIncomeHeadId = get_setting_value(Settings::ALIYA_FEES_INCOME_HEAD);
        $aliyaAdmissionIncomeHeadId = get_setting_value(Settings::ALIYA_ADMISSION_INCOME_HEAD);
        $otherFeesIncomeHeadId = get_setting_value(Settings::OTHER_FEES_INCOME_HEAD);

        $branches = Branch::all();

        foreach ($branches as $branch) {

            $this->processDailyCollection($branch->id, $nuraniFeesIncomeHeadId, 1, Accounting::TUITION, 'Nurani Fee Collection');
            $this->processDailyCollection($branch->id, $aliyaFeesIncomeHeadId, 2, Accounting::TUITION, 'Aliya Fee Collection');
            $this->processDailyCollection($branch->id, $hifzBoysFeesIncomeHeadId, 3, Accounting::TUITION, 'Hifz Boys Fee Collection');
            $this->processDailyCollection($branch->id, $hifzGirlsFeesIncomeHeadId, 4, Accounting::TUITION, 'Hifz Girls Fee Collection');
            $this->processDailyCollection($branch->id, $kawmiFeesIncomeHeadId, 5, Accounting::TUITION, 'Kawmi Fee Collection');

            
            $this->processDailyCollection($branch->id, $examFeeIncomeHeadId, null, Accounting::EXAM, 'Exam Fee Collection');
            
            $this->processDailyCollection($branch->id, $nuraniAdmissionIncomeHeadId, 1, Accounting::ADMISSION, 'Nurani Admission Collection');
            $this->processDailyCollection($branch->id, $aliyaAdmissionIncomeHeadId, 2, Accounting::ADMISSION, 'Aliya Admission Collection');
            $this->processDailyCollection($branch->id, $hifzBoysAdmissionIncomeHeadId, 3, Accounting::ADMISSION, 'Hifz Boys Admission Collection');
            $this->processDailyCollection($branch->id, $hifzGirlsAdmissionIncomeHeadId, 4, Accounting::ADMISSION, 'Hifz Girls Admission Collection');
            $this->processDailyCollection($branch->id, $kawmiAdmissionIncomeHeadId, 5, Accounting::ADMISSION, 'Kawmi Admission Collection');

            $this->processDailyCollectionOtherFees($branch->id, $otherFeesIncomeHeadId, 'Other Fee Collection');

        }
    }

    private function processDailyCollection($branchId, $headId, $feeCode, $description)
    {
        $today = Carbon::now()->toDateString();
        $collection = InvoiceItem::withoutGlobalScope(BranchFilterScope::class)
            ->whereDate('payment_date', $today)
            ->where('branch_id', $branchId)
            ->where('fee_code', $feeCode)
            ->whereNotNull('payment_date')
            ->sum('amount');

        if ($collection > 0) {
            Income::create([
                'branch_id' => $branchId,
                'invoice_no' => Income::withoutGlobalScope(BranchFilterScope::class)->max('invoice_no') + 1,
                'accounting_head_id' => $headId,
                'income_date' => $today,
                'amount' => $collection,
                'description' => $description,
            ]);
        }
    }

    private function processDailyCollectionOtherFees($branchId, $headId, $description)
    {
        $today = Carbon::now()->toDateString();
        $collection = InvoiceItem::withoutGlobalScope(BranchFilterScope::class)
            ->whereDate('payment_date', $today)
            ->where('branch_id', $branchId)
            ->whereNotIn('fee_code', [Accounting::EXAM, Accounting::TUITION, Accounting::ADMISSION])
            ->whereNotNull('payment_date')
            ->sum('amount');

        if ($collection > 0) {
            Income::create([
                'branch_id' => $branchId,
                'invoice_no' => Income::withoutGlobalScope(BranchFilterScope::class)->max('invoice_no') + 1,
                'accounting_head_id' => $headId,
                'income_date' => $today,
                'amount' => $collection,
                'description' => $description,
            ]);
        }
    }

}