<?php

namespace App\Services\Accounting;

use App\Constants\Common;
use App\Constants\Status;
use App\Models\HrPayroll\SalaryGrade;
use App\Models\HrPayroll\SalaryGradeRule;
use App\Models\HrPayroll\SalaryHead;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SalarySettingService
{
    public function getRelatedData()
    {
        return [
            'salaryHeads' => SalaryHead::all(),
            'salaryRuleType' => Common::SALARY_RULE_TYPE,
            'salaryGrades' => SalaryGrade::with('salaryGradeRules')->get(),
        ];
    }

    //============Head Function Start=============//
    public function storeHead(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required',
            'type' => 'required|in:E,D',
        ]);

        SalaryHead::create($validatedData);
    }

    public function updateHead(Request $request, SalaryHead $salaryHead)
    {
        $validatedData = $request->validate([
            'title' => 'required',
            'type' => 'required|in:E,D',
        ]);

        $salaryHead->update($validatedData);
    }

    //============Grade Function Start=============//
    public function storeGrade(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required',
            'type' => 'required|in:Percentage,Fixed',
        ]);


        $salaryGradeRule = $request->except(['_token', '_method', 'title', 'type', 'id']);

        $salaryHeads = SalaryHead::pluck('id', 'code');

        $salaryGrade = SalaryGrade::create([
            'title' => $request->title,
            'status' => Status::ACTIVE,
        ]);

        foreach ($salaryGradeRule as $headCode => $value) {
            SalaryGradeRule::create([
                'salary_grade_id' => $salaryGrade->id,
                'salary_head_id' => $salaryHeads[$headCode],
                'rule_type' => $request->type,
                'amount' => $value,
            ]);
        }

    }

    public function updateGrade(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'type' => 'required',
        ]);

        $salaryGrade = SalaryGrade::find($id);

        $salaryGrade->update([
            'title' => $request->title,
            'code' => Str::upper(Str::slug($request->title)),
        ]);

        $salaryGradeRules = $request->except(['_token', '_method', 'title', 'type','id']);

        $salaryHeads = SalaryHead::pluck('id', 'code');

        foreach ($salaryGradeRules as $key => $value) {

            $salaryGradeRule = SalaryGradeRule::where('salary_grade_id', $id)->where('salary_head_id', $salaryHeads[$key])->first();
            if ($salaryGradeRule) {
                $salaryGradeRule->update([
                    'rule_type' => $request->type,
                    'amount' => $value,
                ]);
            } else {
                SalaryGradeRule::create([
                    'salary_grade_id' => $id,
                    'salary_head_id' => $salaryHeads[$key],
                    'rule_type' => $request->type,
                    'amount' => $value,
                ]);
            }
        }
    }

    public function deleteGrade($id)
    {
        $salaryGrade = SalaryGrade::find($id);
        SalaryGradeRule::where('salary_grade_id', $id)->delete();
        $salaryGrade->delete();
    }

}
