<?php

namespace App\Services;

use App\Filters\StudentInfoFilter;
use App\Models\Student\StudentInfo;

class HostelService
{


    public function get(array $queryParams = [])
    {
        if(empty($queryParams)){
            return [];
        }
        
        $queryBuilder = StudentInfo::with(['branch', 'shift','section','studentClass', 'studentHostel', 'studentHostelRoom'])->latest();

        $students = resolve(StudentInfoFilter::class)->getResults([
            'builder' => $queryBuilder,
            'params' => $queryParams
        ]);

        return $students->get();
    }
}
