<?php
namespace App\Services\Reports;

use Log;
use App\Models\Result\Exam;
use App\Models\Result\Grade;
use App\Models\Result\ExamRecord;
use App\Models\Result\MarkHeadAssign;

class ExamGradeCount
{
    public function gradeCount22($exam_id = null)
    {
        $exam = Exam::orderBy('id', 'desc')->find($exam_id)
            ?? Exam::orderBy('id', 'desc')->first();

        $exam_id = $exam->id;
        $academic_year = $exam->year;
        $branch_id = auth()->user()->branch_id;

        // Grades (ordered high → low)
        $grades = Grade::orderByDesc('mark_from')->get();

        // Exam records of ACTIVE students only
        $examRecords = ExamRecord::where('exam_id', $exam_id)
            ->where('year', $academic_year)
            ->where('branch_id', $branch_id)
            ->whereHas('student', fn ($q) => $q->where('status', 'active'))
            ->get()
            ->groupBy('student_id');

        $letterGradeCount = [];

        foreach ($examRecords as $student_id => $records) {

            $totalGPA = 0;
            $subjectCount = 0;
            $hasFail = false;

            $class_id = $records->first()->class_id;

            $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)
                ->where('student_class_id', $class_id)
                ->pluck('head_marks', 'subject_id');

            foreach ($records->groupBy('subject_id') as $subject_id => $subjectRecords) {

                $subjectTotal = $subjectRecords->sum('total_marks');
                $headMarks = json_decode($assignedMarksHead[$subject_id] ?? '[]', true);
                $fullMark = array_sum(array_map('floatval', $headMarks));

                if ($fullMark <= 0) continue;

                $percentage = ($subjectTotal / $fullMark) * 100;

                $grade = $grades->first(fn ($g) =>
                    $percentage >= $g->mark_from && $percentage <= $g->mark_to
                );

                if ($grade) {
                    $totalGPA += $grade->gpa;
                    $subjectCount++;

                    if ($grade->name === 'F') {
                        $hasFail = true;
                    }
                }
            }

            // Final GPA
            $finalGPA = $hasFail ? 0 : round($totalGPA / max($subjectCount, 1), 2);

            // Convert GPA → Letter Grade
            $finalGrade = $grades->first(fn ($g) => $finalGPA >= $g->gpa)->name ?? 'F';

            $letterGradeCount[$finalGrade] =
                ($letterGradeCount[$finalGrade] ?? 0) + 1;
        }

        return $letterGradeCount;
    }


    public function gradeCount($exam_id = null)
    {
        $exam_id =  $exam_id != null ? $exam_id : getCurrentActiveExamId(); 
        $academic_year = Exam::where('id', $exam_id)->first()->year;
        $brach_id = auth()->user()->branch_id;

        $grades = Grade::select('id', 'name', 'gpa', 'mark_from', 'mark_to')
            ->orderByDesc('mark_from')
            ->get();

        $examRecords = ExamRecord::where('exam_id', $exam_id)
            ->where('year', $academic_year)
            ->where('branch_id', $brach_id)
            ->get();

        $recordsByStudent = $examRecords->groupBy('student_id');

        $studentGrades = [];

        foreach ($recordsByStudent as $student_id => $records) {
            $subjectGrades = []; // subject_id => grade_name

            $student_class_id = $records->first()->class_id ?? null;

            $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)
                ->where('student_class_id', $student_class_id)
                ->pluck('head_marks', 'subject_id');

            $subjectWise = $records->groupBy('subject_id');

            foreach ($subjectWise as $subject_id => $subjectRecords) {
                $subjectTotal = $subjectRecords->sum('total_marks');

                // Decode JSON head_marks and sum them
                $rawMarkJson = $assignedMarksHead[$subject_id] ?? null;
                $headMarksArray = $rawMarkJson ? json_decode($rawMarkJson, true) : [];
                $fullMark = array_sum(array_map('floatval', $headMarksArray));

                if ($fullMark > 0) {
                    $percentage = ($subjectTotal / $fullMark) * 100;

                    $grade = $grades->first(function ($g) use ($percentage) {
                        return $percentage >= $g->mark_from && $percentage <= $g->mark_to;
                    });

                    if ($grade) {
                        $subjectGrades[$subject_id] = $grade->name;
                    } else {
                        $subjectGrades[$subject_id] = 'N/A';
                    }
                } else {
                    $subjectGrades[$subject_id] = 'N/A';
                }
            }

            $studentGrades[$student_id] = $subjectGrades;
        }



        $studentGPAs = [];

        foreach ($recordsByStudent as $student_id => $records) {
            $totalGPA = 0;
            $subjectCount = 0;
            $hasFail = false;

            // Get student's class to load correct mark distribution
            $student_class_id = $records->first()->class_id ?? null;

            // Load full marks for this student's class
            $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)
                ->where('student_class_id', $student_class_id)
                ->pluck('head_marks', 'subject_id');

            // Group by subject
            $subjectWise = $records->groupBy('subject_id');

            foreach ($subjectWise as $subject_id => $subjectRecords) {
                $subjectTotal = $subjectRecords->sum('total_marks');

                $rawMarkJson = $assignedMarksHead[$subject_id] ?? null;

                $headMarksArray = $rawMarkJson ? json_decode($rawMarkJson, true) : [];

                $fullMark = array_sum(array_map('floatval', $headMarksArray));


                if ($fullMark > 0) {
                    $percentage = ($subjectTotal / $fullMark) * 100;

                    $grade = $grades->first(function ($g) use ($percentage) {
                        return $percentage >= $g->mark_from && $percentage <= $g->mark_to;
                    });

                    if ($grade) {
                        $totalGPA += $grade->gpa;
                        $subjectCount++;

                        if ($grade->name === 'F') {
                            $hasFail = true;
                        }
                    }
                } else {
                    Log::warning("Missing full mark for subject_id = $subject_id, student_id = $student_id");
                }
            }

            $finalGPA = $hasFail ? 0.00 : round($totalGPA / max($subjectCount, 1), 2);
            $studentGPAs[$student_id] = $finalGPA;
        }

        return $studentGPAs;
    }


}