<?php
namespace App\Services\Reports;

use App\Models\Academic\Group;
use App\Models\Attendance\StudentAttendance;

class StudentAttendanceReportService
{

    public function filterItems($filters)
    {

        $studentAttendance = StudentAttendance::query();

        if(isset($filters['student_class_id'])) {
            $studentAttendance->where('student_class_id', $filters['student_class_id']);
        }
        if(isset($filters['shift_id'])) {
            $studentAttendance->where('shift_id', $filters['shift_id']);
        }
        
        if(!empty($filters['student_id'])){
            $studentAttendance->with(['studentInfo' => function ($query) use ($student_id){
                $query->where('student_id_no', $student_id);
            }]);
        }else{
            $studentAttendance->with(['studentInfo' ]);
        }
        $attendances = $studentAttendance
        ->select('student_id') // Select the unique column ->orderBy('class_roll','asc')
        ->selectRaw('SUM(student_attendances.is_present = 1) as totoal_present')
        ->selectRaw('SUM(student_attendances.is_absent = 1) as totoal_absent')
        ->selectRaw('SUM(student_attendances.is_late = 1) as totoal_late')
        ->selectRaw('COUNT(*) as punch_date')
        ->groupBy('student_id') // Group by the unique column
        ->get();

        return $attendances;

        // $query = Suppliers::query()->where('archive_status', 0);
  
        // if (isset($filters['name'])) {
        //     $query->where('name', $filters['name']);
        // }

        // if (isset($filters['email'])) {
        //     $query->where('email', $filters['email']);
        // }

        // if (isset($filters['phone'])) {
        //     $query->where('phone', $filters['phone']);
        // }

        // if (isset($filters['status'])) {
        //     $query->where('status', $filters['status']);
        // }

        // if (isset($filters['start_date']) && isset($filters['end_date'])) {
        //     // Convert start and end dates to the required format
        //     $startDate = date('Y-m-d 00:00:00', strtotime($filters['start_date']));
        //     $endDate = date('Y-m-d 23:59:59', strtotime($filters['end_date']));
        //     // Ensure $query is updated, not $data
        //     $query->whereBetween('created_at', [$startDate, $endDate]);
        // }

        // return $query;
    }

}