<?php

namespace App\Services;

use App\Models\Setting;
use App\Constants\Accounting;
use Illuminate\Support\Facades\Cache;
use App\Models\Accounting\AccountingHead;

class SettingService
{
    protected $fileUploadService;

    public function __construct(FileUploadService $fileUploadService)
    {
        $this->fileUploadService = $fileUploadService;
    }

    // public function updateSettings($request)
    // {
    //     $filter = Setting::pluck('key')->toArray();

    //     dd($request->all(),$filter );
    //     $data = $request->only($filter);

    //     foreach ($data as $key => $value) {
    //         if ($request->hasFile($key)) {
    //             $this->handleFileUpload($request, $key);
    //         } else {
    //             Setting::where('key', $key)->where('branch_id', auth()->user()->branch_id)->update([
    //                 'value' => $value,
    //                 'branch_id' => auth()->user()->branch_id ?? 1
    //             ]);
    //         }
    //         Cache::forget("setting_{$key}");
    //     }
    // }

    public function updateSettings($request)
    {
        $branchId = auth()->user()->branch_id ?? 1;
        $settings = [];
        // dd($request->all(), $settings);
        foreach ($request->all() as $key => $value) {
            if (in_array($key, ['_token', '_method'])) {
                continue;
            }
            
            $exist = Setting::where('key', $key)->where('branch_id', $branchId)->select('key','value','branch_id')->first();
            if($exist){
                if ($request->hasFile($key)) {
                    $this->handleFileUpload($request, $key);
                } else {
                    Setting::where('key', $key)->where('branch_id', $branchId)->update(['value' => $value]);
                }
            }else{
                if ($request->hasFile($key)) {
                    $this->handleFileUpload($request, $key);
                } else {
                    Setting::updateOrCreate(
                        ['key' => $key, 'branch_id' => $branchId],
                        ['value' => $value]
                    );
                } 
            }
            $settings[$key] = $value;
        }
        // Optional: return saved settings or success message
        return response()->json([
            'message' => 'Settings updated successfully.',
            'settings' => $settings
        ]);
    }



    public function handleFileUpload($request, $key)
    {
        $branchId = auth()->user()->branch_id;
        if ($request->hasFile($key)) {
            $file = $request->file($key);
            $previousFile = Setting::where('key', $key)->first();
            $filePath = $this->fileUploadService->upload($file, 'uploads/settings', $previousFile->value ?? '');
            // dd($request->all(), $filePath);
            $exist = Setting::where('key', $key)->where('branch_id', $branchId)->select('key','value','branch_id')->first();


            if($exist){
                Setting::where('key', $key)->where('branch_id', $branchId)->update(['value' => $filePath]);
            }else{
                Setting::updateOrCreate(
                    ['key' => $key, 'branch_id' => $branchId],
                    ['value' => $filePath]
                );
            }
        }
    }

    public function getSetting($key)
    {
        //Cache data for 30 days = 43200 minutes
        return Cache::remember("setting_{$key}", 43200, function () use ($key) {
            $setting = Setting::where('key', $key)->first();
            if (empty($setting)) {
                $setting = Setting::create([
                    'key' => $key,
                    'branch_id' => auth()->user()->branch_id ?? ""
                ]);
                Cache::put("setting_{$key}", $setting, 43200);
            }
            return $setting;
        });
    }

    public function getRelatedData()
    {
        return [
            'settings' => Setting::all(),
            'expense_heads' => AccountingHead::where('type', Accounting::EXPENSE)->pluck('name', 'id'),
            'income_heads' => AccountingHead::where('type', Accounting::INCOME)->pluck('name', 'id'),
        ];
    }
}
